' BrightAuthor PJLink プラグイン
' Copyright (C) 2019 Japan Material Co., Ltd.
'
' 用途：
'   PJLink対応のプロジェクターにコマンドを送信する
' 
' 使い方：
'   1. プラグインの追加
'   1.1 〈ファイル＞プレゼンテーションのプロパティ＞オートラン〉を開く。
'   1.2 〈スクリプトのプラグインを追加〉をクリックし、プラグイン一覧に新しい行を追加する。
'   1.3 追加された行で〈参照〉をクリックし、このファイルを追加する。
'   1.4 プラグインの名前を《pjlink》に設定する。
'   2. 必要な設定を行う
'   2.1 〈ファイル＞プレゼンテーションのプロパティ＞変数〉を開く。
'   2.2 変数の追加をクリックし、変数一覧に新しい行を追加する。
'   2.3 名前に《pjlinkAddress》を入力し、デフォルト値にプロジェクターのIPアドレスを入力する。
'   2.4 必要に応じて同様に《pjlinkPassword》も設定する。
'   3. プレゼンテーションにコマンドを追加する。
'   3.1 メディアやイベントのプロパティで〈アドバンス〉タブを開く。
'   3.2 〈コマンドの追加〉をクリックし、コマンド一覧に新しい行を追加する。
'   3.3 コマンドに〈送信〉、コマンドパラメーターに〈プラグインメッセージの送信＞pjlink〉を設定する。
'   3.3 右側の入力フィールドに任意のPJLinkコマンドを入力する。
'       例：プロジェクターの電源を入れる場合は《POWR 1》
'       例：プロジェクターの電源を消す場合は《POWR 0》
'
' ユーザ変数
'   pjlinkAddress
'     プロジェクターのIPアドレス
'   pjlinkPassword
'     プロジェクターのPJLink用パスワード
'
' 留意点
'   ローカルWebサーバーを有効にすると変数が閲覧でき、またダイアグノスティックWebサーバーを有効にす
'   るとスクリプトファイルが閲覧できる。パスワードのセキュリティに注意してください。

Function pjlink_Initialize(msgPort As Object, userVariables As Object, bsp As Object)
  ' 初期値（ユーザ変数の設定がない場合に使われる）
  PJLINK_DEFAULT_ADDRESS$ = "192.168.0.1"
  PJLINK_DEFAULT_PASSWORD$ = "JBMIAProjectorLink"

  ' プラグインオブジェクトを返す
  return {
    objectName      : "pjlink_object",
    msgPort         : msgPort,
    bsp             : bsp,
    userVariables   : userVariables,
    pjlinkAddress$  : PJLINK_DEFAULT_ADDRESS$,
    pjlinkPassword$ : PJLINK_DEFAULT_PASSWORD$,
    systemLog       : CreateObject("roSystemLog"),

    ProcessEvent    : Function (event As Object)
      ' プラグインメッセージを受信
      if type(event) = "roAssociativeArray" then
        if type(event["EventType"]) = "roString"
          if event["EventType"] = "SEND_PLUGIN_MESSAGE" then
            if event["PluginName"] = "pjlink" then
              m.SendCommand(event["PluginMessage"])
              ' 他のイベント処理装置にこのイベントを処理させない場合はtrueを返す
              return true
            endif
          endif
        endif
      endif
      ' 他のプラグインやイベント処理装置にこのイベントの処理を許す場合はfalseを返す
      return false
    End Function

    SendCommand     : Function (pluginMessage$ as String) as Void
      ' ユーザ変数からアドレスとパスワードを取得する
      if m.userVariables.DoesExist("pjlinkAddress") then
        m.pjlinkAddress$ = m.userVariables.Lookup("pjlinkAddress").currentvalue$
      endif
      if m.userVariables.DoesExist("pjlinkPassword") then
        m.pjlinkPassword$ = m.userVariables.Lookup("pjlinkPassword").currentvalue$
      endif
      print #m.systemLog, "PJLink plugin: send ";pluginMessage$;" to ";m.pjlinkAddress$
      ' プロジェクターに接続する
      socket = CreateObject("roTCPStream")
      lineEventPort = CreateObject("roMessagePort")
      socket.SetLineEventPort(lineEventPort)
      socket.SetReceiveEol(chr(13)) ' CR
      socket.SetSendEol(chr(13)) ' CR
      if socket.ConnectTo(m.pjlinkAddress$, 4352) then
        ' 接続できた、返信を待つ
        lineEvent = Wait(500, lineEventPort)
        if type(lineEvent) = "roStreamLineEvent" then
          if Left(lineEvent, 8) = "PJLINK 1" then
            ' 乱数を抽出して、ダイジェストを生成する
            random$ = Mid(lineEvent, 10, 8)
            print #m.systemLog, "PJLink plugin: random: ";random$
            randompass$ = random$ + m.pjlinkPassword$
            hashGenerator = CreateObject("roHashGenerator", "MD5")
            digestBytes = hashGenerator.Hash(randompass$)
            digest$ = LCase(digestBytes.ToHexString())
            ' 認証通信
            msg$ = digest$ + "%1" + pluginMessage$
            print #m.systemLog, "PJLink plugin: command: ";msg$
            socket.SendLine(msg$)
            lineEvent = Wait(500, lineEventPort)
            if type(lineEvent) = "roStreamLineEvent" then
              print #m.systemLog, "PJLink plugin: receive: ";lineEvent
            endif
          else if lineEvent = "PJLINK 0" then
            ' 非認証通信
            msg$ = "%1" + pluginMessage$
            print #m.systemLog, "PJLink plugin: command: ";msg$
            socket.SendLine(msg$)
            lineEvent = Wait(500, lineEventPort)
            if type(lineEvent) = "roStreamLineEvent" then
              print #m.systemLog, "PJLink plugin: receive: ";lineEvent
            endif
          endif
        else
          print #m.systemLog, "PJLink plugin: timeout: ";type(lineEvent)
        endif
      else
        print #m.systemLog, "PJLink plugin: failure: ";socket.GetFailureReason()
      endif
    End Function
  }
End Function
