Sub Main()

	Print "Script to set Date, Time and Time Zone"

	s = {}
	s.VideoResolution$="1920x1080x60p"
	s.sTime = createObject("roSystemTime")
	s.CurrentTimeIs = s.sTime.GetLocalDateTime()
	s.p = createobject("roMessagePort")
    s.mode = CreateObject("roVideoMode")
    s.mode.SetMode(s.VideoResolution$)
	s.ResX = s.mode.GetResX()
	s.ResY = s.mode.GetResY()
	s.ParseAndSetDateTime = ParseAndSetDateTime
	s.registry = CreateObject("roRegistry")
	s.registrySection = CreateObject("roRegistrySection", "ManualDateTimeSet")
	s.ReadRegistryval = ReadRegistryval
	s.RegistryTZValue$ = ""
	
	Daterect = CreateObject("roRectangle", s.ResX / 4, s.ResY / 16, s.ResX / 2, s.ResY / 8)
	Timerect = CreateObject("roRectangle", s.ResX / 4, s.ResY / 4, s.ResX / 2, s.ResY / 8)
	s.TZRect = CreateObject("roRectangle", s.ResX / 4, s.ResY / 2, s.ResX / 2, s.ResY / 8)
	InfoRect = CreateObject("roRectangle", s.ResX / 4, s.ResY / 2 + s.ResY / 4, s.ResX / 2, s.ResY / 8)
	res = CreateObject("roResourceManager", "resources.txt")
	res.SetLanguage("eng")
	DateWidget = CreateObject("roClockWidget", Daterect, res, 0)
	TimeWidget = CreateObject("roClockWidget", Timerect, res, 1)
	InfoWidget = CreateObject("roTextWidget", InfoRect, 3, 2, {Alignment: "1"})
	s.TZWidget = CreateObject("roTextWidget", s.TZRect, 3, 2, {Alignment: "1"})
	
	
	DateWidget.Show()
	TimeWidget.Show()
	
	OldRegistryValue = s.ReadRegistryval()
	
	
	if OldRegistryValue <> "" then
	
		
		oldTimeZone = s.sTime.GetTimeZone()
		
		s.TZWidget.PushString("Time zone is currently set to: " + oldTimeZone)
		InfoWidget.PushString("Date, Time and Time zone already set!!! To reset please clear the registry first, then re-run this script.")
		InfoWidget.Show()
		s.TZWidget.Show()
		
		
	else 
		
		
			s.newTimezone = s.sTime.GetTimeZone()	
		
			s.registrySection.Write("NewTimeZone", s.newTimezone)
			s.registry.flush()
			s.TZWidget.PushString("Time zone is currently set to: " + s.newTimezone)
			InfoWidget.PushString("Date, Time and Time Zone almost set on the Player. The player will reboot in 10 seconds.")
			InfoWidget.Show()			
			s.TZWidget.Show()
			sleep(10000)
			
			ok = s.ParseAndSetDateTime()
			
			RebootSystem()
		
	end if
		
	
	While true

		msg = wait(0, s.p)
	
	End while
	
	
End Sub



Function GetEOL(file as String)

	eol = chr(13) + chr(10)   '/r/n, Windows/DOS File
	if instr(1, file, eol) = 0 then
		eol = chr(13)   '/r, Mac
		if instr(1, file, eol) = 0 then
			eol = chr(10)   '/n, Linux
			if instr(1, file, eol) = 0 then
				if debug then print "No EOL found"
				eol = chr(13) + chr(10)   '/r/n, Windows/DOS File
			endif
		endif
	endif

	'eoln = len(eol)
	
	return eol

End Function


Function ParseAndSetDateTime()

	filename = "SetDateAndTime.txt"
	file = ReadAsciiFile(filename)
	eol = GetEOL(file)
	eoln = len(eol)
	
	index_tz = 0

	TZPosStart = instr(index_tz, file, " ")	   
	TZPosEnd = instr(index_tz, file, eol)	   
	m.timezoneVal$ = mid(file, TZPosStart + 1, TZPosEnd - 1 - TZPosStart)
	YearPosStart = instr(TZPosEnd, file, " ")	   
	YearPosEnd = instr(YearPosStart , file, "/")	   
	m.yearVal =  val(mid(file, YearPosStart + 1, YearPosEnd - 1 - YearPosStart))	  	   
	MonthPosStart = instr(YearPosEnd - 1, file, "/")	   
	MonthPosEnd = instr(MonthPosStart + 1, file, "/")	   
	m.MonthVal = val(mid(file, MonthPosStart + 1, MonthPosEnd - 1 - MonthPosStart))	   
	DayPosStart = instr(MonthPosEnd - 1, file, "/")	   
	DayPosEnd = instr(DayPosStart + 1, file, " ")	   
	m.DayVal = val(mid(file, DayPosStart + 1, DayPosEnd - 1 - DayPosStart))	      	   
	HourPosStart = DayPosEnd	   
	HourPosEnd = HourPosStart + 3	   
	m.HourVal = val(mid(file, HourPosStart + 1, HourPosEnd - 1 - HourPosStart))	   
	MinutesPosStart = HourPosEnd	   
	MinutesPosEnd = MinutesPosStart + 3	   
	m.MinutesVal = val(mid(file, MinutesPosStart + 1, MinutesPosEnd - 1 - MinutesPosStart))

	m.sTime.SetTimeZone(m.timezoneVal$)
	
	localDateTime = m.sTime.GetLocalDateTime()
    localDateTime.SetYear(m.yearVal)
    localDateTime.SetMonth(m.MonthVal)
    localDateTime.SetDay(m.DayVal)
    localDateTime.SetHour(m.HourVal)
    localDateTime.SetMinute(m.MinutesVal)
    localDateTime.SetSecond(0)
    
	ok = m.sTime.SetLocalDateTime(localDateTime)	
	
	return ok
		
End Function


Function ReadRegistryval()

	if m.registrySection.Exists("NewTimeZone") then
		m.RegistryTZValue$ = m.registrySection.Read("NewTimeZone")
	end if
	
	return m.RegistryTZValue$
	
End Function
